/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter;

import java.util.UUID;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SoundTools;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.blocks.DialingDeviceTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterTransmitterTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import mcjty.rftoolsutility.setup.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.registries.ForgeRegistries;

public class TeleportationTools {
    public static final int STATUS_OK = 0;
    public static final int STATUS_WARN = 1;
    public static final int STATUS_UNKNOWN = 2;
    public static MobEffect confusion;
    public static MobEffect harm;
    public static MobEffect wither;

    public static void getPotions() {
        if (confusion == null) {
            confusion = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("nausea"));
            harm = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("instant_damage"));
            wither = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("wither"));
        }
    }

    public static void applyEffectForSeverity(Player player, int severity, boolean boostNeeded) {
        TeleportationTools.getPotions();
        switch (severity) {
            case 1: {
                if (!boostNeeded) break;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                player.m_6469_(DamageSource.f_19318_, 0.5f);
                break;
            }
            case 4: {
                player.m_6469_(DamageSource.f_19318_, 0.5f);
                break;
            }
            case 5: {
                player.m_6469_(DamageSource.f_19318_, 1.0f);
                break;
            }
            case 6: {
                player.m_6469_(DamageSource.f_19318_, 1.0f);
                break;
            }
            case 7: {
                player.m_6469_(DamageSource.f_19318_, 2.0f);
                break;
            }
            case 8: {
                player.m_6469_(DamageSource.f_19318_, 2.0f);
                break;
            }
            case 9: {
                player.m_6469_(DamageSource.f_19318_, 3.0f);
                break;
            }
            case 10: {
                player.m_6469_(DamageSource.f_19318_, 3.0f);
            }
        }
    }

    public static int calculateRFCost(Level world, BlockPos c1, TeleportDestination teleportDestination) {
        if (!world.m_46472_().equals(teleportDestination.getDimension())) {
            return (Integer)TeleportConfiguration.rfStartTeleportBaseDim.get();
        }
        BlockPos c2 = teleportDestination.getCoordinate();
        double dist = new Vec3((double)c1.m_123341_(), (double)c1.m_123342_(), (double)c1.m_123343_()).m_82554_(new Vec3((double)c2.m_123341_(), (double)c2.m_123342_(), (double)c2.m_123343_()));
        int rf = (Integer)TeleportConfiguration.rfStartTeleportBaseLocal.get() + (int)((double)((Integer)TeleportConfiguration.rfStartTeleportDist.get()).intValue() * dist);
        if (rf > (Integer)TeleportConfiguration.rfStartTeleportBaseDim.get()) {
            rf = (Integer)TeleportConfiguration.rfStartTeleportBaseDim.get();
        }
        return rf;
    }

    public static int calculateTime(Level world, BlockPos c1, TeleportDestination teleportDestination) {
        if (!world.m_46472_().equals(teleportDestination.getDimension())) {
            return (Integer)TeleportConfiguration.timeTeleportBaseDim.get();
        }
        BlockPos c2 = teleportDestination.getCoordinate();
        double dist = new Vec3((double)c1.m_123341_(), (double)c1.m_123342_(), (double)c1.m_123343_()).m_82554_(new Vec3((double)c2.m_123341_(), (double)c2.m_123342_(), (double)c2.m_123343_()));
        int time = (Integer)TeleportConfiguration.timeTeleportBaseLocal.get() + (int)((double)((Integer)TeleportConfiguration.timeTeleportDist.get()).intValue() * dist / 1000.0);
        if (time > (Integer)TeleportConfiguration.timeTeleportBaseDim.get()) {
            time = (Integer)TeleportConfiguration.timeTeleportBaseDim.get();
        }
        return time;
    }

    public static boolean performTeleport(Player player, TeleportDestination dest, int bad, int good, boolean boosted) {
        BlockPos c = dest.getCoordinate();
        BlockPos old = new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_());
        ResourceKey oldId = player.m_20193_().m_46472_();
        if (!TeleportationTools.allowTeleport((Entity)player, (ResourceKey<Level>)oldId, old, dest.getDimension(), dest.getCoordinate())) {
            return false;
        }
        if (!oldId.equals(dest.getDimension())) {
            mcjty.lib.varia.TeleportationTools.teleportToDimension((Player)player, dest.getDimension(), (double)((double)c.m_123341_() + 0.5), (double)((double)c.m_123342_() + 1.5), (double)((double)c.m_123343_() + 0.5));
        } else {
            player.m_6021_((double)c.m_123341_() + 0.5, (double)(c.m_123342_() + 1), (double)c.m_123343_() + 0.5);
        }
        if (((Boolean)TeleportConfiguration.whooshMessage.get()).booleanValue()) {
            Logging.message((Player)player, (String)"Whoosh!");
        }
        boolean boostNeeded = false;
        int severity = TeleportationTools.consumeReceiverEnergy(player, dest.getCoordinate(), dest.getDimension());
        if (severity > 0 && boosted) {
            boostNeeded = true;
            severity = 1;
        }
        if ((severity = TeleportationTools.applyBadEffectIfNeeded(player, severity, bad, good, boostNeeded)) <= 0 && (Double)TeleportConfiguration.teleportVolume.get() >= 0.01) {
            SoundTools.playSound((Level)player.m_20193_(), (SoundEvent)ModSounds.whoosh, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (double)((Double)TeleportConfiguration.teleportVolume.get()), (double)1.0);
        }
        if (((Boolean)TeleportConfiguration.logTeleportUsages.get()).booleanValue()) {
            Logging.log((String)("Teleport: Player " + player.m_7755_() + " from " + old + " (dim " + oldId + ") to " + dest.getCoordinate() + " (dim " + dest.getDimension() + ") with severity " + severity));
        }
        return boostNeeded;
    }

    public static int dial(Level worldObj, DialingDeviceTileEntity dialingDeviceTileEntity, UUID player, BlockPos transmitter, ResourceKey<Level> transDim, BlockPos coordinate, ResourceKey<Level> dimension, boolean once) {
        ServerLevel transWorld = LevelTools.getLevel(transDim);
        if (transWorld == null) {
            return 256;
        }
        MatterTransmitterTileEntity transmitterTileEntity = (MatterTransmitterTileEntity)transWorld.m_7702_(transmitter);
        if (transmitterTileEntity == null) {
            return 1024;
        }
        if (player != null && !transmitterTileEntity.checkAccess(player)) {
            return 32;
        }
        if (coordinate == null) {
            transmitterTileEntity.setTeleportDestination(null, false);
            return 128;
        }
        TeleportDestination teleportDestination = TeleportationTools.findDestination(worldObj, coordinate, dimension);
        if (teleportDestination == null) {
            return 4;
        }
        BlockPos c = teleportDestination.getCoordinate();
        ServerLevel recWorld = LevelTools.getLevel(teleportDestination.getDimension());
        if (recWorld == null && (recWorld = LevelTools.getLevel((Level)worldObj, teleportDestination.getDimension())) == null) {
            return 4;
        }
        BlockEntity tileEntity = recWorld.m_7702_(c);
        if (!(tileEntity instanceof MatterReceiverTileEntity)) {
            return 4;
        }
        MatterReceiverTileEntity receiver = (MatterReceiverTileEntity)tileEntity;
        TeleportDestination destination = receiver.updateDestination();
        if (player != null && !destination.checkAccess((Level)recWorld, player)) {
            return 64;
        }
        if (!TeleportationTools.checkBeam(transmitter, (Level)transWorld, 1, 4, 2)) {
            return 2;
        }
        if (dialingDeviceTileEntity != null && !dialingDeviceTileEntity.getCapability(CapabilityEnergy.ENERGY).map(h -> {
            int defaultCost = (Integer)TeleportConfiguration.rfPerDial.get();
            int cost = dialingDeviceTileEntity.getCapability(CapabilityInfusable.INFUSABLE_CAPABILITY).map(inf -> (int)((float)defaultCost * (2.0f - inf.getInfusedFactor()) / 2.0f)).orElse(defaultCost);
            if (h.getEnergyStored() < cost) {
                return false;
            }
            ((GenericEnergyStorage)h).consumeEnergy((long)cost);
            return true;
        }).orElse(false).booleanValue()) {
            return 8;
        }
        transmitterTileEntity.setTeleportDestination(teleportDestination, once);
        return 0;
    }

    private static int consumeReceiverEnergy(Player player, BlockPos c, ResourceKey<Level> dimension) {
        ServerLevel world = LevelTools.getLevel((Level)player.f_19853_, dimension);
        if (world == null) {
            Logging.warn((Player)player, (String)"Something went wrong with the destination!");
            return 0;
        }
        BlockEntity te = world.m_7702_(c);
        if (!(te instanceof MatterReceiverTileEntity)) {
            Logging.warn((Player)player, (String)"Something went wrong with the destination!");
            return 0;
        }
        MatterReceiverTileEntity receiver = (MatterReceiverTileEntity)te;
        return receiver.getCapability(CapabilityEnergy.ENERGY).map(h -> {
            int defaultCost = (Integer)TeleportConfiguration.rfPerTeleportReceiver.get();
            int rf = receiver.getCapability(CapabilityInfusable.INFUSABLE_CAPABILITY).map(inf -> (int)((float)defaultCost * (2.0f - inf.getInfusedFactor()) / 2.0f)).orElse(defaultCost);
            if (rf <= 0) {
                return 0;
            }
            int extracted = Math.min(rf, h.getEnergyStored());
            ((GenericEnergyStorage)h).consumeEnergy((long)rf);
            long remainingRf = ((GenericEnergyStorage)h).getEnergy();
            if (remainingRf <= 1L) {
                Logging.warn((Player)player, (String)"The matter receiver has run out of power!");
            } else if (remainingRf < (long)((Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get() / 10)) {
                Logging.warn((Player)player, (String)"The matter receiver is getting very low on power!");
            } else if (remainingRf < (long)((Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get() / 5)) {
                Logging.warn((Player)player, (String)"The matter receiver is getting low on power!");
            }
            return 10 - extracted * 10 / rf;
        }).orElse(0);
    }

    public static int calculateSeverity(int bad, int total) {
        if (total == 0) {
            total = 1;
        }
        int severity = bad * 10 / total;
        if (TeleportationTools.mustInterrupt(bad, total)) {
            severity += 2;
        }
        if (severity > 10) {
            severity = 10;
        }
        return severity;
    }

    public static int applyBadEffectIfNeeded(Player player, int severity, int bad, int total, boolean boostNeeded) {
        if (player == null) {
            return 0;
        }
        if ((severity += TeleportationTools.calculateSeverity(bad, total)) > 10) {
            severity = 10;
        }
        if (severity <= 0) {
            return 0;
        }
        if ((Double)TeleportConfiguration.teleportErrorVolume.get() >= 0.01) {
            SoundTools.playSound((Level)player.m_20193_(), (SoundEvent)ModSounds.error, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (double)((Double)TeleportConfiguration.teleportErrorVolume.get()), (double)1.0);
        }
        TeleportationTools.applyEffectForSeverity(player, severity, boostNeeded);
        return severity;
    }

    public static boolean mustInterrupt(int bad, int total) {
        return bad > total / 2;
    }

    public static boolean allowTeleport(Entity entity, ResourceKey<Level> sourceDim, BlockPos source, ResourceKey<Level> destDim, BlockPos dest) {
        return true;
    }

    public static TeleportDestination findDestination(Level worldObj, BlockPos coordinate, ResourceKey<Level> dimension) {
        TeleportDestinations destinations = TeleportDestinations.get(worldObj);
        return destinations.getDestination(coordinate, dimension);
    }

    public static boolean checkBeam(BlockPos c, Level world, int dy1, int dy2, int errory) {
        for (int dy = dy1; dy <= dy2; ++dy) {
            BlockPos pos = new BlockPos(c.m_123341_(), c.m_123342_() + dy, c.m_123343_());
            if (world.m_8055_(pos).m_60795_()) continue;
            if (dy > errory) break;
            return false;
        }
        return true;
    }

    public static boolean checkValidTeleport(Player player, ResourceKey<Level> srcId, ResourceKey<Level> dstId) {
        if (((Boolean)TeleportConfiguration.preventInterdimensionalTeleports.get()).booleanValue() && srcId.equals(dstId)) {
            Logging.warn((Player)player, (String)"Teleportation in the same dimension is not allowed!");
            return false;
        }
        if (TeleportConfiguration.getBlacklistedTeleportationDestinations().contains(dstId)) {
            Logging.warn((Player)player, (String)"Teleportation to that dimension is not allowed!");
            return false;
        }
        if (TeleportConfiguration.getBlacklistedTeleportationSources().contains(srcId)) {
            Logging.warn((Player)player, (String)"Teleportation from this dimension is not allowed!");
            return false;
        }
        return true;
    }
}

